import numpy as np
import array as arr

np.set_printoptions(formatter={'int': hex})
""" 
convertFlashtoCpu
CPU    Flash
AD00    DQ15
AD01    DQ07
AD02    DQ14
AD03    DQ06
AD04    DQ13
AD05    DQ05
AD06    DQ12
AD07    DQ04
AD08    DQ11
AD09    DQ03
AD10    DQ10
AD11    DQ02
AD12    DQ09
AD13    DQ01
AD14    DQ08
AD15    DQ00
"""
def convertFlashtoCpu(byte1, byte2):
    inputBuffer = np.array([byte2, byte1], dtype=np.uint8)
    #print("Buffer:", inputBuffer)
    bitBuffer = np.unpackbits(inputBuffer, axis=0, count=16)
    #print("Convertiere zu Bits:", bitBuffer)
    # Tausche Bits:
    swapBuffer = np.array([
        bitBuffer[15],
        bitBuffer[7],
        bitBuffer[14],
        bitBuffer[6],
        bitBuffer[13],
        bitBuffer[5],
        bitBuffer[12],
        bitBuffer[4],
        bitBuffer[11],
        bitBuffer[3],
        bitBuffer[10],
        bitBuffer[2],
        bitBuffer[9],
        bitBuffer[1],
        bitBuffer[8],
        bitBuffer[0],
    ], dtype=np.uint8)
    #print("Swapbuffer:", swapBuffer)

    outputBuffer = np.packbits(swapBuffer, axis=0)
    outputBuffer = np.array([outputBuffer[1], outputBuffer[0]], dtype=np.uint8)
    #print("Output: ", outputBuffer)

    return [outputBuffer[0], outputBuffer[1]]

""" 
convertCPUtoFlash

CPU    Flash
AD15    DQ00
AD13    DQ01
AD11    DQ02
AD9     DQ03
AD7     DQ04
AD5     DQ05
AD3     DQ06
AD1     DQ07
AD14    DQ08
AD12    DQ09
AD10    DQ10
AD8     DQ11
AD6     DQ12
AD4     DQ13
AD2     DQ14
AD0     DQ15
"""
def convertCPUtoFlash(byte1, byte2):
    inputBuffer = np.array([byte2, byte1], dtype=np.uint8)
    #print("Buffer:", inputBuffer)
    bitBuffer = np.unpackbits(inputBuffer, axis=0, count=16)
    #print("Convertiere zu Bits:", bitBuffer)
    # Tausche Bits:
    swapBuffer = np.array([
        bitBuffer[15],
        bitBuffer[13],
        bitBuffer[11],
        bitBuffer[9],
        bitBuffer[7],
        bitBuffer[5],
        bitBuffer[3],
        bitBuffer[1],
        bitBuffer[14],
        bitBuffer[12],
        bitBuffer[10],
        bitBuffer[8],
        bitBuffer[6],
        bitBuffer[4],
        bitBuffer[2],
        bitBuffer[0],
    ], dtype=np.uint8)
    #print("Swapbuffer:", swapBuffer)

    outputBuffer = np.packbits(swapBuffer, axis=0)
    outputBuffer = np.array([outputBuffer[1], outputBuffer[0]], dtype=np.uint8)
    #print("Output: ", outputBuffer)

    return [outputBuffer[0], outputBuffer[1]]




#!/usr/bin/python

import sys, getopt

def main(argv):
   inputfile = ''
   outputfile = ''
   try:
      opts, args = getopt.getopt(sys.argv[1:],"hi:o:",["ifile=","ofile="])
   except getopt.GetoptError:
      print('test.py -i <inputfile> -o <outputfile>')
      sys.exit(2)
   for opt, arg in opts:
      if opt == '-h':
         print('main.py -i <inputfile> -o <outputfile>')
         sys.exit()
      elif opt in ("-i", "--ifile"):
         inputfile = arg
      elif opt in ("-o", "--ofile"):
         outputfile = arg

   inputfile = sys.argv[1]
   if(inputfile == ""):
       print('Usage')
       print('main.py -i <inputfile> -o <outputfile>')
       sys.exit()
   if (outputfile == ""):
       import os
       outputfile = os.path.splitext(inputfile)[0]
       outputfile = outputfile + "_converted.bin"

   print ('Input file:', inputfile)
   print ('Output file:', outputfile)

   inputfile = open(inputfile, "rb")
   outputfile = open(outputfile, "wb")

   CPU2FLASH = 1
   FLASH2CPU = 2
   fileHeader = inputfile.read(1)
   if (fileHeader[0] == 0xFA):
       print("Converting from CPU to Flash")
       convertMethod = CPU2FLASH
   else:
       print("Converting from Flash to CPU")
       convertMethod = FLASH2CPU
   print("...")

   inputfile.seek(0)

   while True:
       buffer = inputfile.read(2)
       if len(buffer) != 2:
           break

       if not buffer:
           break

       if(convertMethod == CPU2FLASH):
           buffer2 = convertCPUtoFlash(buffer[0], buffer[1])

       if(convertMethod == FLASH2CPU):
           buffer2 = convertFlashtoCpu(buffer[0], buffer[1])

       outputfile.write(buffer2[0])
       outputfile.write(buffer2[1])
   print("Finished!")


if __name__ == "__main__":
   main(sys.argv[1:])







